/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.dltk.compiler.problem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org2.eclipse.dltk.compiler.problem.AbstractProblemReporter;
import org2.eclipse.dltk.compiler.problem.CategorizedProblem;
import org2.eclipse.dltk.compiler.problem.IProblem;
import org2.eclipse.dltk.compiler.problem.IProblemReporter;
import org2.eclipse.dltk.compiler.task.ITaskReporter;

public class ProblemCollector
extends AbstractProblemReporter
implements ITaskReporter {
    protected final List<IProblem> problems = new ArrayList<IProblem>();

    public void reset() {
        this.problems.clear();
    }

    @Override
    public void reportProblem(IProblem problem) {
        this.problems.add(problem);
    }

    @Override
    public void reportTask(String message, int lineNumber, int priority, int charStart, int charEnd) {
        this.reportProblem(new TaskInfo(message, lineNumber, priority, charStart, charEnd));
    }

    public boolean isEmpty() {
        return this.problems.isEmpty();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (ITaskReporter.class.equals((Object)adapter) || IProblemReporter.class.equals((Object)adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean hasErrors() {
        if (!this.problems.isEmpty()) {
            for (IProblem problem : this.problems) {
                if (!problem.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public void copyTo(IProblemReporter destination) {
        for (IProblem problem : this.problems) {
            destination.reportProblem(problem);
        }
    }

    public List<IProblem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public List<IProblem> getErrors() {
        ArrayList<IProblem> result = new ArrayList<IProblem>();
        for (IProblem problem : this.problems) {
            if (!problem.isError()) continue;
            result.add(problem);
        }
        return result;
    }

    protected static class TaskInfo
    extends CategorizedProblem {
        private final String message;
        private final int charStart;
        private final int lineNumber;
        private final int charEnd;
        private final int priority;

        public TaskInfo(String message, int lineNumber, int priority, int charStart, int charEnd) {
            this.message = message;
            this.lineNumber = lineNumber;
            this.priority = priority;
            this.charEnd = charEnd;
            this.charStart = charStart;
        }

        @Override
        public int getCategoryID() {
            return 0;
        }

        @Override
        public String getMarkerType() {
            return "com.aptana.editor.php.epl.task";
        }

        @Override
        public String[] getArguments() {
            return null;
        }

        @Override
        public int getID() {
            return 536871362;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getOriginatingFileName() {
            return null;
        }

        @Override
        public int getSourceEnd() {
            return this.charEnd;
        }

        @Override
        public int getSourceLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getSourceStart() {
            return this.charStart;
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public boolean isWarning() {
            return false;
        }

        @Override
        public void setSourceEnd(int sourceEnd) {
        }

        @Override
        public void setSourceLineNumber(int lineNumber) {
        }

        @Override
        public void setSourceStart(int sourceStart) {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Task");
            sb.append(' ');
            sb.append(this.lineNumber);
            sb.append('[');
            sb.append(this.charStart);
            sb.append("..");
            sb.append(this.charEnd);
            sb.append(']');
            sb.append(':');
            if (this.message != null) {
                sb.append(this.message);
            }
            return sb.toString();
        }
    }
}

